#include "asm.h"
#include "sparcasm.h"
#include "format.h"
#include "core.h"
#include "symbol.h"
SRCFILE("sparcasm.c")

#define A ARG_NO

struct sparcoptab sparcoptab[] = {
{"nop",	0x01000000,	OP0_MASK,	0,	0 },
{"ret",	0x81C7E008,	OP0_MASK,	0,	0 },
{"restore",0x81E80000,	OP0_MASK,	0,	0 },
{"ldsb",0xC0480000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	0 },
{"ldsh",0xC0500000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	0 },
{"ldub",0xC0080000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	0 },
{"lduh",0xC0100000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	0 },
{"ld",	0xC0000000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	0 },
{"ldd",	0xC0180000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	0 },
{"ldstub",0xC0680000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	0 },
{"swap",0xC0780000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	0 },
{"stb",	0xC0280000,	OP3A_MASK,	ARG_RD|A(1,ARG_ISL),	0 },
{"sth",	0xC0300000,	OP3A_MASK,	ARG_RD|A(1,ARG_ISL),	0 },
{"st",	0xC0200000,	OP3A_MASK,	ARG_RD|A(1,ARG_ISL),	0 },
{"std",	0xC0380000,	OP3A_MASK,	ARG_RD|A(1,ARG_ISL),	0 },
{"add",	0x80000000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"addcc",0x80800000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"addx",0x80400000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"addxcc",0x80C00000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"taddcc",0x81000000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"taddcctv",0x81100000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"sub",	0x80200000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"cmp",	0x80A00000,	OP3A_MASK|RD_MASK,	ARG_RS1|A(1,ARG_IRI),	0 },
{"subcc",0x80A00000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"subx",0x80600000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"subxcc",0x80E00000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"tsubcc",0x81080000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"tsubcc",0x81180000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"mulscc",0x81200000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"and",	0x80080000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"andcc",0x80880000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"andn",0x80280000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"andncc",0x80A80000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"clr",	0x80100000,	OP3A_MASK|RS1_MASK|RS2_MASK|I_BIT,	ARG_RD,	0 },
{"mov",	0x80100000,	OP3A_MASK|RS1_MASK,	ARG_IRI|A(1,ARG_RD),	0 },
{"or",	0x80100000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"orcc",0x80900000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"orn",	0x80300000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"orncc",0x80B00000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"xor",	0x80180000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"xorcc",0x80980000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"xnor",0x80380000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"xnor",0x80B80000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"sll",	0x81280000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"srl",	0x81300000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"sra",	0x81380000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"save",0x81E00000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"restore",0x81E80000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RD),	0 },
{"jmp",0x81C00000,	OP3A_MASK|RD_MASK,	ARG_ISL,	FLAG_NOBRAC },
{"call",0x9FC00000,	OP3A_MASK|RD_MASK,	ARG_ISL,	FLAG_NOBRAC },
{"jmpl",0x81C00000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	FLAG_NOBRAC },
{"sethi",0x01000000,	OP2A_MASK,	ARG_IMM22|A(1,ARG_RD),	0 },
{"call",0x40000000,	OP1_MASK,	ARG_DISP30,		0 },
{"bn",	0x00800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"be",	0x02800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"ble",	0x04800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bl",	0x06800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bleu",0x08800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bcs",	0x0A800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bneg",0x0C800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bvs",	0x0E800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"ba",	0x10800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bne",	0x12800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bg",	0x14800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bge",	0x16800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bgu",	0x18800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bcc",	0x1A800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bpos",0x1C800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"bvc",	0x1E800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"ld",	0xC1000000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	FLAG_FLTREG },
{"ldd",	0xC1180000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	FLAG_FLTREG },
{"ld",	0xC1080000,	OP3A_MASK,	ARG_ISL|A(1,ARG_REGSR),	FLAG_FLTREG },
{"st",	0xC1200000,	OP3A_MASK,	ARG_RD|A(1,ARG_ISL),	FLAG_FLTREG },
{"std",	0xC1380000,	OP3A_MASK,	ARG_RD|A(1,ARG_ISL),	FLAG_FLTREG },
{"st",	0xC1280000,	OP3A_MASK,	ARG_REGSR|A(1,ARG_ISL),	FLAG_FLTREG },
{"sd",	0xC1300000,	OP3A_MASK,	ARG_REGQ|A(1,ARG_ISL),	FLAG_FLTREG },
{"fbn",	0x01800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbne",0x03800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fblg",0x05800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbul",0x07800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbl",	0x09800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbug",0x0B800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbg",	0x0D800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbu",	0x0F800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fba",	0x11800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbe",	0x13800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbue",0x15800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbge",0x17800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fble",0x19800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fpuge",0x1B800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbule",0x1D800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fbo",	0x1F800000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"fitos",0x81A01880,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fitod",0x81A01900,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fitox",0x81A01980,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fstoir",0x81A01820,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fdtoir",0x81A01840,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fxtoir",0x81A01860,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fstoi",0x81A01A20,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fdtoi",0x81A01A40,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fxtoi",0x81A01A60,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fstod",0x81A01920,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fstox",0x81A019A0,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fdtos",0x81A018C0,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fdtox",0x81A019C0,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fxtos",0x81A018E0,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fxtod",0x81A01960,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fmovs",0x81A00020,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fnegs",0x81A000A0,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fabss",0x81A00120,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fsqrts",0x81A00520,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fsqrtd",0x81A00540,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fsqrtx",0x81A00560,	OP3B_MASK,	ARG_RS2|A(1,ARG_RD),	FLAG_FLTREG },
{"fadds",0x81A00820,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"faddd",0x81A00840,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"faddx",0x81A00860,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fsubs",0x81A008A0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fsubd",0x81A008C0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fsubx",0x81A008E0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fmuls",0x81A00920,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fmuld",0x81A00940,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fmulx",0x81A00960,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fdivs",0x81A009A0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fdivd",0x81A009C0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fdivx",0x81A009E0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2)|A(2,ARG_RD), FLAG_FLTREG },
{"fcmps",0x81A10A20,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2),	FLAG_FLTREG },
{"fcmpd",0x81A10A40,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2),	FLAG_FLTREG },
{"fcmpx",0x81A10A60,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2),	FLAG_FLTREG },
{"fcmpes",0x81A10AA0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2),	FLAG_FLTREG },
{"fcmped",0x81A10AC0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2),	FLAG_FLTREG },
{"fcmpex",0x81A10AE0,	OP3B_MASK,	ARG_RS1|A(1,ARG_RS2),	FLAG_FLTREG },
{"mov",	0x81400000,	OP3A_MASK,	ARG_RSPEC|A(1,ARG_RD),		0 },
{"mov",	0x81480000,	OP3A_MASK,	ARG_RSPEC|A(1,ARG_RD),		0 },
{"mov",	0x81500000,	OP3A_MASK,	ARG_RSPEC|A(1,ARG_RD),		0 },
{"mov",	0x81580000,	OP3A_MASK,	ARG_RSPEC|A(1,ARG_RD),		0 },
{"wr",	0x81800000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RSPEC),	0 },
{"wr",	0x81880000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RSPEC),	0 },
{"wr",	0x81900000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RSPEC),	0 },
{"wr",	0x81980000,	OP3A_MASK,	ARG_RS1|A(1,ARG_IRI)|A(2,ARG_RSPEC),	0 },
{"unimp",0x00000000,	OP2A_MASK,	0,			0 },
{"iflush",0x81D80000,	OP3A_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"ta",	0x91D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tn",	0x81D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tne",	0x93D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"te",	0x83D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tg",	0x95D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tle",	0x85D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tge",	0x97D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tl",	0x87D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tgu",	0x99D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tleu",0x89D00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tcc",	0x9BD00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tcs",	0x8BD00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tpos",0x9DD00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tneg",0x8DD00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tvc",	0x9FD00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"tvs",	0x8FD00000,	OP3C_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"rett",0x81C80000,	OP3A_MASK,	ARG_ISL,		FLAG_NOBRAC },
{"ldsba",0xC0C80000,	OP3A_MASK,	ARG_ASI|A(1,ARG_RD),	0 },
{"ldsha",0xC0D00000,	OP3A_MASK,	ARG_ASI|A(1,ARG_RD),	0 },
{"lduba",0xC0880000,	OP3A_MASK,	ARG_ASI|A(1,ARG_RD),	0 },
{"lduha",0xC0900000,	OP3A_MASK,	ARG_ASI|A(1,ARG_RD),	0 },
{"lda",	0xC0800000,	OP3A_MASK,	ARG_ASI|A(1,ARG_RD),	0 },
{"ldda",0xC0980000,	OP3A_MASK,	ARG_ASI|A(1,ARG_RD),	0 },
{"ldstuba",0xC0E80000,	OP3A_MASK,	ARG_ASI|A(1,ARG_RD),	0 },
{"swapa",0xC0F80000,	OP3A_MASK,	ARG_ASI|A(1,ARG_RD),	0 },
{"stba",0xC0A80000,	OP3A_MASK,	ARG_RD|A(1,ARG_ASI),	0 },
{"stha",0xC0B00000,	OP3A_MASK,	ARG_RD|A(1,ARG_ASI),	0 },
{"sta",	0xC0A00000,	OP3A_MASK,	ARG_RD|A(1,ARG_ASI),	0 },
{"stda",0xC0B80000,	OP3A_MASK,	ARG_RD|A(1,ARG_ASI),	0 },
{"ld",	0xC1800000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	FLAG_CPREG },
{"ldd",	0xC1980000,	OP3A_MASK,	ARG_ISL|A(1,ARG_RD),	FLAG_CPREG },
{"ld",	0xC1880000,	OP3A_MASK,	ARG_ISL|A(1,ARG_REGSR),	FLAG_CPREG },
{"st",	0xC1A00000,	OP3A_MASK,	ARG_RD|A(1,ARG_ISL),	FLAG_CPREG },
{"std",	0xC1B80000,	OP3A_MASK,	ARG_RD|A(1,ARG_ISL),	FLAG_CPREG },
{"st",	0xC1A80000,	OP3A_MASK,	ARG_REGSR|A(1,ARG_ISL),	FLAG_CPREG },
{"sd",	0xC1B00000,	OP3A_MASK,	ARG_REGQ|A(1,ARG_ISL),	FLAG_CPREG },
{"cbn",	0x01C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb123",0x03C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb12",0x05C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb13",0x07C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb1",	0x09C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb23",0x0BC00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb2",	0x0DC00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb3",	0x0FC00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cba",	0x11C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb0",	0x13C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb03",0x15C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb02",0x17C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb01",0x19C00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb023",0x1BC00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb013",0x1DC00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{"cb012",0x1FC00000,	OP2B_MASK,	ARG_DISP22,		FLAG_ANNUL },
{0,	0,		0,		0,			0 },
};

SparcInstr::SparcInstr(Asm*a,long l):Instr(a,l)	{ display(); }
char *SparcAsm::literaldelimiter()		{ return ""; }
SparcAsm::SparcAsm(Core *c):Asm(c)		{ }

Instr *SparcAsm::newInstr(long a)
{
	return (Instr*) new SparcInstr(this,a);
}

char *SparcInstr::regarg(char *lay, long f)
{
	static char t[128];
	char *o, *r;
	Var *v;

	r = _asm->core->regname(reg);
	o = Format(f&~F_SYMBOLIC).f(m.lng);
	if( f&F_SYMBOLIC ){
		if( reg == _asm->core->REG_AP() ){
			if( v = local(U_ARG, m.lng) )
				o = v->text();
			else if( v = local(U_AUT, m.lng) )
				o = v->text();
		} else {
			if( v = local(U_REG, reg) ){
				r = sf("%s=%s", v->text(), r);
				if( v = field(v, m.lng) )
					o = v->text();
			}
		}
	}
	sprintf(t, lay, r, o);
	return t;
}

char *SparcInstr::arg(int argnumber)
{
	static char t[128];
	long l;
	char *r, *s;
	m.lng = 0;

	switch (argtype(argnumber)) {
	case ARG_DISP30:
		m.lng = ((opword & DISP30_MASK) << 2) + addr;
		return symbolic();
	case ARG_DISP22:
		l = (opword & DISP22_MASK);
		if (l & 0x00200000)	// Check sign bit
			l |= ~DISP22_MASK;
		m.lng = (l << 2) + addr;
		return symbolic();
	case ARG_IMM22:
		m.lng = (opword & IMM22_MASK) << 10;
		return sf("%%hi(%s)", literal(fmt));
	case ARG_RD:
		reg = (char)RD_FIELD(opword);
		if (tab->flags & FLAG_FLTREG)
			return sf("%%f%d", reg);
		if (tab->flags & FLAG_CPREG)
			return sf("%%c%d", reg);
		return regarg("%%%s%s", fmt&F_SYMBOLIC|F_NONE);
	case ARG_RS1:
		reg = (char)RS1_FIELD(opword);
		if (tab->flags & FLAG_FLTREG)
			return sf("%%f%d", reg);
		return regarg("%%%s%s", fmt&F_SYMBOLIC|F_NONE);
	case ARG_RS2:
		reg = (char)RS1_FIELD(opword);
		return sf("%%f%d", reg);
	case ARG_RSPEC:
		{
		static char *specnames[] = { "%%y", "%%psr", "%%wim", "%%tbr" };
		return specnames[RSPEC_FIELD(opword)];
		}
	case ARG_REGSR:
		if (tab->flags & FLAG_FLTREG)
			return "%%fsr";
		return "%%csr";
	case ARG_REGQ:
		if (tab->flags & FLAG_FLTREG)
			return "%%fq";
		return "%%cq";
	case ARG_ASI:
		reg = (char)RS1_FIELD(opword);
		s = regarg("%%%s%s", fmt&F_SYMBOLIC|F_NONE);
		strcpy(t, s);
		reg = (char)RS2_FIELD(opword);
		r = regarg("%%%s%s", fmt&F_SYMBOLIC|F_NONE);
		m.lng = ASI_FIELD(opword);
		s = literal(fmt);
		return sf("[%s+%s]%s", t, r, s);
	case ARG_IRI:
		if (opword & I_BIT) {
			m.lng = SIMM13_FIELD(opword);
			return literal(fmt);
		}
		reg = (char)RS2_FIELD(opword);
		return regarg("%%%s%s", fmt&F_SYMBOLIC|F_NONE);
	case ARG_ISL:
		if (opword & I_BIT) {
			m.lng = SIMM13_FIELD(opword);
			reg = (char)RS1_FIELD(opword);
			if (tab->flags & FLAG_NOBRAC)
				s = regarg("%%%s+%s", fmt&F_SYMBOLIC|F_SIGNED);
			else
				s = regarg("[%%%s+%s]", fmt&F_SYMBOLIC|F_SIGNED);
		} else {
			reg = (char)RS1_FIELD(opword);
			s = regarg("%%%s%s", fmt&F_SYMBOLIC|F_NONE);
			strcpy(t, s);
			reg = (char)RS2_FIELD(opword);
			r = regarg("%%%s%s", fmt&F_SYMBOLIC|F_NONE);
			if (tab->flags & FLAG_NOBRAC)
				s = sf("%s+%s", t, s);
			else
				s = sf("[%s+%s]", t, s);
		}
		return s;
	default:
		return "arg";
	}
}

int SparcInstr::nargs()
{
	for (int j = 0; (ARG_MASK << ARG_SHIFT(j)) & args; j++)
		;
	return j;
}

int SparcInstr::argtype(int i)
{
	return (args >> ARG_SHIFT(i)) & ARG_MASK;
}

char *SparcInstr::mnemonic()
{
	next = addr+4;
	opword =  _asm->core->peekcode(addr)->lng;
	for( tab = sparcoptab; tab->opname; ++tab ) {
		if ((opword & tab->opmask) == tab->opcode) {
			args = tab->args;
			if ( (tab->flags & FLAG_ANNUL) &&
			     (opword & ANNUL_BIT) ) {
				return sf("%s{a}", tab->opname);
			}
			return tab->opname;
		}
	}
	return sf("0x%x", opword);
}
